/* Default tables for general import.  This file contains the default font and character
mapping tables,  can be shared by all importers. */

#include "CPUDEFS.H"
#include "pgdeftbl.h"

#ifdef MAC_PLATFORM

// Default cross-font table (if input == ansi):

pg_char PG_FAR cross_font_table[] = {

	"Arial*[Avant Garde]\0"
	"Book*[Bookman]\0"
	"Century Gothic[Avant Garde]\0"
	"Century Sch*[New Century Schoolbook]\0"
	"Courie*[Courier]\0"
	"FixedSys[Chicago]\0"
	"Helvetic*[Helvetica]\0"
	"Monotype Cors*[Zapf Chancery]\0"
	"MS S*[Geneva]\0"
	"Roman[New York]\0"
	"Script[Zapf Chancery]\0"
	"Small Fonts[Monaco]\0"
	"Terminal[Monaco]\0"
	"Times*[Times]\0"
	"Tms Rmn[Times]\0"
	"WingDings[Zapf Dingbats]\0"
	"\ff"
};

// Font type table (for RTF):

pg_char PG_FAR font_type_table[] = {
	"Avant Garde[fswiss\0"
	"Bookman[froman\0"
	"Chicago[fswiss\0"
	"Courier[fmodern\0"
	"Geneva[fswiss\0"
	"Helvetica[fswiss\0"
	"Monaco[fmodern\0"
	"N Helvetic*[fswiss\0"
	"New York[froman\0"
	"Old Eng*[fdecorative\0"
	"Palatino[froman\0"
	"Symbol[ftech\0"
	"Times[froman\0"
	"Zapf Chancery[fscript\0"
	"Zapf Dingbats[ftech\0"
	"\ff"
};

// Cross char > 0x80 table when running on Macintosh:

pg_char PG_FAR cross_character_table[HIGH_CHARS_QTY] = {
	N_A, N_A, 0xE2, 0xC4, N_A, 0xC9, 0xA0, 0xE0,		/* 80-87 */
	0xF6, 0xE4, N_A, 0xDC, 0xCE, N_A, N_A, N_A,			/* 88-8F */
	N_A, 0xD4, 0xD5, 0xD2, 0xD3, 0xA5, 0xD1, 0xD0,		/* 90-97 */
	0xF7, 0xAA, N_A, 0xDD, 0xCF, 0xD9, N_A, N_A,		/* 98-9F */
	0xCA, 0xC1, 0xA2, 0xA3, 0xDB, 0xB4, N_A, 0xA4,		/* A0-A7 */
	0xAC, 0xA9, 0xBB, 0xC7, 0xC2, 0x1F, 0xA8, 0xF8,		/* A8-AF */
	0xA1, 0xB1, N_A, N_A, 0xAB, 0xB5, 0xA6, 0xE1,		/* B0-B7 */
	0xFC, N_A, 0xBC, 0xC8, N_A, N_A, N_A, 0xC0,			/* B8-BF */
	0xCB, 0xE7, 0xE5, 0xCC, 0x80, 0x81, 0xAE, 0x82,		/* C0-C7 */
	0xE9, 0x83, 0xE6, 0xE8, 0xED, 0xEA, 0xEB, 0xEC,		/* C8-CF */
	N_A, 0x84, 0xF1, 0xEE, 0xEF, 0xCD, 0x85, N_A,		/* D0-D7 */
	0xAF, 0xF4, 0xF2, 0xF3, 0x86, N_A, N_A, 0xA7,		/* D8-DF */
	0x88, 0x87, 0x89, 0x8B, 0x8A, 0x8C, 0xBE, 0x8D,		/* E0-E7 */
	0x8F, 0x8E, 0x90, 0x91, 0x93, 0x92, 0x94, 0x95,		/* E8-EF */
	N_A, 0x96, 0x98, 0x97, 0x99, 0x9B, 0x9A, 0xD6,		/* F0-F7 */
	0xBF, 0x9D, 0x9C, 0x9E, 0x9F, N_A, N_A, N_A			/* F8-FF */
};
#endif
// endif MAC_PLATFORM

#ifdef WINDOWS_PLATFORM

#ifdef UNICODE

// Cross-font names from Macintosh:

pg_char PG_FAR cross_font_table[] = {
	L"Avant Garde[Arial]\0"
	L"Bookman[Times New Roman]\0"
	L"Chicago[FixedSys]\0"
	L"Courier[Courier New]\0"
	L"Geneva[MS Sans Serif]\0"
	L"Helvetica[Arial]\0"
	L"Monaco[Courier New]\0"
	L"N Helvetic*[Arial]\0"
	L"New York[MS Serif]\0"
	L"Palatino[Arial]\0"
	L"Symbol[WingDings]\0"
	L"Times[Times New Roman]\0"
	L"Zapf Chancery[Script]\0"
	L"Zapf Dingbats[WingDings]\0"
	L"\ff"
};

// Font type table:

pg_char PG_FAR font_type_table[] = {
	L"Arial*[fswiss\0"
	L"Book*[froman\0"
	L"Century Gothic[fswiss\0"
	L"Century Sch*[froman\0"
	L"Courie*[fmodern\0"
	L"FixedSys[fswiss\0"
	L"Helvetic*[fswiss\0"
	L"Monotype Cors*[fmodern\0"
	L"MS S*[fswiss\0"
	L"Roman[froman\0"
	L"Script[fscript\0"
	L"Small Fonts[fmodern\0"
	L"Terminal[fmodern\0"
	L"Times*[froman\0"
	L"Tms Rmn[froman\0"
	L"WingDings[ftech\0"
	L"\ff"
};

// Cross characters from Macintosh:

pg_char PG_FAR cross_character_table[HIGH_CHARS_QTY] = {

	0xC4, 0xC5, 0xC7, 0xC9, 0xD1, 0xD6, 0xDC, 0xE1,	/* 80-87 */
	0xE0, 0xE2, 0xE4, 0xE3, 0xE5, 0xE7, 0xE9, 0xE8,	/* 88-8F */
	0xEA, 0xEB, 0xED, 0xEC, 0xEE, 0xEF, 0xF1, 0xF3,	/* 90-97 */
	0xF2, 0xF4, 0xF6, 0xF5, 0xFA, 0xF9, 0xFB, 0xFC,	/* 98-9F */
	0x86, 0xB0, 0xA2, 0xA3, 0xA7, 0x2022, 0xB6, 0xDF,	/* A0-A7 */
	0xAE, 0xA9, 0x99, 0xB4, 0xA8, N_A, 0xC6, 0xD8,	/* A8-AF */
	N_A, 0xB1, N_A, N_A, 0xA5, 0xB5, N_A, N_A,		/* B0-B7 */
	N_A, N_A, N_A, 0xAA, 0xBA, N_A, 0xE6, 0xF8,		/* B8-BF */
	0xBF, 0xA1, 0xAC, N_A, 0x83, N_A, N_A, 0xAB,	/* C0-C7 */
	0xBB, 0x85, 0xA0, 0xC0, 0xC3, 0xD5, 0x8C, 0x9C,	/* C8-CF */
	0x97, 0x96, 0x201C, 0x201D, 0x2018, 0x2019, 0xF7, N_A,	/* D0-D7 */
	N_A, 0x9D, N_A, 0xA4, 0x8B, 0x9B, N_A, N_A,		/* D8-DF */
	0x87, 0xB7, 0x82, N_A, 0x89, 0xC2, 0xCA, 0xC1,	/* E0-E7 */
	0xCB, 0xC8, 0xCD, 0xCE, 0xCF, 0xCC, 0xD3, 0xD4,	/* E8-EF */
	N_A, 0xD2, 0xDA, 0xDB, 0xD9, N_A, 0x88, 0x98,	/* F0-F7 */
	0xAF, N_A, N_A, N_A, 0xB8, N_A, N_A, N_A		/* F8-FF */
};

#else

// Cross-font names from Macintosh:

pg_char PG_FAR cross_font_table[] = {
	"Avant Garde[Arial]\0"
	"Bookman[Times New Roman]\0"
	"Chicago[FixedSys]\0"
	"Courier[Courier New]\0"
	"Geneva[MS Sans Serif]\0"
	"Helvetica[Arial]\0"
	"Monaco[Courier New]\0"
	"N Helvetic*[Arial]\0"
	"New York[MS Serif]\0"
	"Palatino[Arial]\0"
	"Symbol[WingDings]\0"
	"Times[Times New Roman]\0"
	"Zapf Chancery[Script]\0"
	"Zapf Dingbats[WingDings]\0"
	"\ff"
};

// Font type table:

pg_char PG_FAR font_type_table[] = {
	"Arial*[fswiss\0"
	"Book*[froman\0"
	"Century Gothic[fswiss\0"
	"Century Sch*[froman\0"
	"Courie*[fmodern\0"
	"FixedSys[fswiss\0"
	"Helvetic*[fswiss\0"
	"Monotype Cors*[fmodern\0"
	"MS S*[fswiss\0"
	"Roman[froman\0"
	"Script[fscript\0"
	"Small Fonts[fmodern\0"
	"Terminal[fmodern\0"
	"Times*[froman\0"
	"Tms Rmn[froman\0"
	"WingDings[ftech\0"
	"\ff"
};

// Cross characters from Macintosh:

pg_char PG_FAR cross_character_table[HIGH_CHARS_QTY] = {

	0xC4, 0xC5, 0xC7, 0xC9, 0xD1, 0xD6, 0xDC, 0xE1,	/* 80-87 */
	0xE0, 0xE2, 0xE4, 0xE3, 0xE5, 0xE7, 0xE9, 0xE8,	/* 88-8F */
	0xEA, 0xEB, 0xED, 0xEC, 0xEE, 0xEF, 0xF1, 0xF3,	/* 90-97 */
	0xF2, 0xF4, 0xF6, 0xF5, 0xFA, 0xF9, 0xFB, 0xFC,	/* 98-9F */
	0x86, 0xB0, 0xA2, 0xA3, 0xA7, 0x95, 0xB6, 0xDF,	/* A0-A7 */
	0xAE, 0xA9, 0x99, 0xB4, 0xA8, N_A, 0xC6, 0xD8,	/* A8-AF */
	N_A, 0xB1, N_A, N_A, 0xA5, 0xB5, N_A, N_A,		/* B0-B7 */
	N_A, N_A, N_A, 0xAA, 0xBA, N_A, 0xE6, 0xF8,		/* B8-BF */
	0xBF, 0xA1, 0xAC, N_A, 0x83, N_A, N_A, 0xAB,	/* C0-C7 */
	0xBB, 0x85, 0xA0, 0xC0, 0xC3, 0xD5, 0x8C, 0x9C,	/* C8-CF */
	0x97, 0x96, 0x93, 0x94, 0x91, 0x92, 0xF7, N_A,	/* D0-D7 */
	N_A, 0x9D, N_A, 0xA4, 0x8B, 0x9B, N_A, N_A,		/* D8-DF */
	0x87, 0xB7, 0x82, N_A, 0x89, 0xC2, 0xCA, 0xC1,	/* E0-E7 */
	0xCB, 0xC8, 0xCD, 0xCE, 0xCF, 0xCC, 0xD3, 0xD4,	/* E8-EF */
	N_A, 0xD2, 0xDA, 0xDB, 0xD9, N_A, 0x88, 0x98,	/* F0-F7 */
	0xAF, N_A, N_A, N_A, 0xB8, N_A, N_A, N_A		/* F8-FF */
};

#endif
#endif
// endif WINDOWS_PLATFORM

#ifdef UNICODE
pg_char PG_FAR def_font_type[] = {L"fnil\0"};
#else
pg_char PG_FAR def_font_type[] = {"fnil\0"};
#endif
